// test forms

#declare test_bulge=1;
#if (test_bulge>0)
#declare bulge=
bicubic_patch {
  type 1
  flatness 0.01
  u_steps 4
  v_steps 4
  <0, 0, 0>, <1, 0, 0>, <2, 0, 0>, <3, 0,0>,
  <0, 0, 1>, <1, 1, 1>, <2, 1, 1>, <3, 0,1>,
  <0, 0, 2>, <1, 1, 2>, <2, 1, 2>, <3, 0,2>,
  <0, 0, 3>, <1, 0, 3>, <2, 0, 3>, <3, 0,3>
  scale <1,4,1>
  translate <-1.5,0,-1.5>
}

union {
object { bulge rotate 180*x translate <0,0,0> }
object { bulge rotate 000*x translate <3,0,0> }
object { bulge rotate 000*x translate <0,0,3> }
object { bulge rotate 180*x translate <3,0,3> }
 uv_mapping
 pigment {wood scale 0.2}
 finish {ambient 0.7}
 scale 1
 rotate -45*x
 //rotate 45 *z
 translate <-2,3,0>
}
#end

#declare test_mesh=0;
#if (test_mesh>0)
// mesh octagon with smoothed edges
mesh2 {
   vertex_vectors {
      6, 
      <0,1,0>,<1,0,0>, <0,0,1>,
      <-1,0,0>, <0,0,-1>, <0,-1,0>
   }
   normal_vectors {
      6, 
      <0,2,0>,<2,0,0>, <0,0,2>,
      <-2,0,0>, <0,0,-2>, <0,-2,0>
   }
   uv_vectors {
      6,
     <-0.5,-0.5>,<0,-0.5>, <0,0>,
     <0.5,-0.5>,
     <0.5,0>,
     <0.5,0.5>
   }
   face_indices {
      8, 
      <0,1,2>, <0,2,3>, <0,3,4>, <0,4,1>,
      <5,1,2>, <5,2,3>, <5,3,4>, <5,4,1>,
   }
   uv_mapping
   pigment {wood scale 0.2}
   finish {ambient 0.7}
   scale 3
   //rotate -90*x
   //rotate 45 *z
   translate 3*y
}
#end

#declare test_cube=0;
#if (test_cube>0)
//#declare f_rounded_box = function { internal(60) }
// Parameters: x, y, z, P0, P1, P2, P3
    // Four extra parameters required:
    // 1. Radius of curvature. 
    //    Zero gives square corners, 
    //    0.1 gives corners that match "sphere {0,0.1}"
    // 2. scale x
    // 3. scale y
    // 4. scale z
#declare boxf =
isosurface {
function { 
 f_rounded_box (x,y,z,0.0,2,2,2)
 //-f_noise3d (x,y,z)*0.5
 //-f_noise3d (x*2,y*2,z*2)*0.5
 //-f_noise3d (x*4,y*4,z*4)*0.5
 -f_noise3d (x*8,y*8,z*8)*0.25
 -f_noise3d (x*16,y*16,z*16)*0.25
}
max_gradient 2 
open
contained_by { box { -3,3 } }
}
difference {
object { boxf }
box { <-1,-1,-3>,<1,1,3> }   
box { <-1,-1,-3>,<1,1,3> rotate y*90 }   
box { <-1,-1,-3>,<1,1,3> rotate x*90 }   
pigment { color rgb <0.7,0.9,0.7> }
rotate <0,40,40>
translate <0,4,ds>
finish { ambient 0.3 }
}
#end
